% Preamble
clear; close all;
addpath RedsSolds IRFs;

% get indices for variables and shocks
[vrbs, shocks, nvar, nstate, nshock] = defineModel();

% get parameter values
param = setParams();

% define model matrices
[A, B, C] = REE_Solve(vrbs,shocks,nvar,nshock);

% solve using Reds-Solds algorithm
[Br,Cr,Lr,NF]=redsf(A,B,C,nvar,nshock,nstate);
[D,F,G,H] = soldsf(Br,Cr,Lr,nvar,nshock,nstate,NF);

% produce Impulse Response Functions
nIterations = 10;                                                    % set number of iterations ahead
spath       = 'S:\SHARE\drf\DSGELearning\Save\IRFs\';                % choose where to save IRFs
savePlots   = 1;
allIRFs = getIRFs(nIterations,shocks,nshock,nvar,D,F,G,H);           % get matrix of all IRFs
plotIRFs(allIRFs,vrbs,shocks,nshock,nIterations,spath,savePlots);    % plot and save IRFs

